/**
 *  TGL ΥѥΤλϥƥ lex ե
 *
 * Notice:
 *  ܤΣϤ˺ܤäƤ tglc.lex ΥץΡ
 *  (Comment)λϤ˸꤬ޤ
 *  ΥץǤϥȤϤǤ褦˽Ƥޤ
 *
 */

%{
using namespace std;

#include <stdio.h>
#include <string>
#include "symtable.h"
#include "error.h"
#include "const.h"
#include "y.tab.h"

int yylexlinenum = 0;		// ֹ
%}

%option yylineno


LineTerminator 	\r|\n|\r\n
WhiteSpace	{LineTerminator}|[ \t\f]

Identifier	 [A-Za-z_][A-Za-z0-9_]*
Digits		0|[1-9][0-9]*
OneLineComment	"//"[^\r\n]*{LineTerminator}
Comment		"/*"([^*]|"*"("*")*[^*/])*"*"("*")*"/"

%%

"var"     { return VAR; }
"func"    { return FUNC; }
"comm"    { return COMM; }
"if"      { return IF; }
"elsif"   { return ELSIF; }
"else"    { return ELSE; }
"while"   { return WHILE; }
"repeat"  { return REPEAT; }
"return"  { return RETURN; }

{Identifier}  { yylval.symbol = new string(yytext);
                return ID; }

{Digits}      { yylval.num = atoi(yytext);
                return NUM; }

"'"."'"       { yylval.num = *(yytext+1);
                return NUM; }
"'".          { compileError(EUnclosedChar); }

"+"    { yylval.op = Cadd;
         return ADDOP; }
"-"    { yylval.op = Csubtract;
         return ADDOP; }
"*"    { yylval.op = Cmultiply;
         return MULOP; }
"/"    { yylval.op = Cdivide;
         return MULOP; }
"%"    { yylval.op = Cmodulo;
         return MULOP; }
">"    { yylval.op = CgreaterThan;
         return RELOP; }
"<"    { yylval.op = ClessThan;
         return RELOP; }
">="   { yylval.op = CgreaterThanOrEqual;
         return RELOP; }
"<="   { yylval.op = ClessThanOrEqual;
         return RELOP; }
"=="   { yylval.op = Cequal;
         return RELOP; }
"!="   { yylval.op = CnotEqual;
         return RELOP; }

"{"    { return '{'; }
"}"    { return '}'; }
"("    { return '('; }
")"    { return ')'; }

","    { return ','; }
"@"    { return '@'; }
"="    { return '='; }
";"    { return ';'; }

{Comment}
{OneLineComment}
{WhiteSpace}    

.        { compileError(EIllegalChar,*yytext,*yytext); }
           

%%

/* ϷϤ                              */
/*   filename: ϥץ̾                        */
/*   ֤: ʤ                                      */
/*   :   yyin ˥եݥ󥿤 */
void initializeScanner(char *filename)
{
  // ϥץΥե򳫤
  if ((yyin=fopen(filename,"r")) == NULL)
    errorExit(EFileNotFound,filename);
  // ֹ
  //  lineNo = 1;
  // ե뤫ʸɤ߹ɤʸХåե˳Ǽ
  //  currentChar = getCharacter();
}

#define TRUE 1

int yywrap()
{
  return TRUE;
}
