/*
 * 쐬: 2008/07/13
 * author: Taro Suzuki
 *
 * C^v^`sʂ̒`
 * 
 */
package tgl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import javax.swing.JPanel;

/**
 * tgl̃C^v^`sʁB̕`Ɖʂ̃NAAL[{[h
 * ͂ꂽǂ̒A͂ꂽ̎擾sB
 * KeyListenerĂ̂ŁAL[{[h當͂ƁA̕
 * 󂯎ăobt@Ɋi[B
 */
public class DrawingScreen extends JPanel implements KeyListener {
  private static final long serialVersionUID = 1202921692647705604L;
  private Image display;
  private CharacterBuffer buffer = null;
  static private final double MinX = -200.0;
  static private final double MinY = -200.0;
  static private final double MaxX = 200.0;
  static private final double MaxY = 200.0;
  static private final int Width = 600;
  static private final int Height = 600;
  
  /**
   * tgl ̃C^v^`spl̃CX^X쐬B
   * 쐬CX^XL[͂̃Xi[ƂĐݒ肷B
   * ɂAL[{[h͂ꂽɑ΂鏈\ɂȂB
   * L[{[h͂ꂽ́Ã\bhō쐬ꂽNX
   *  CharacterBuffer ̃CX^Xłobt@ɕۑB
   */
  DrawingScreen() {
    setSize(new Dimension(Width,Height));
    setBackground(Color.WHITE);
    buffer = new CharacterBuffer();
    addKeyListener(this);
  }

  /**
   * ̃NX̃CX^XtH[JX󂯎悤ɂB
   * ɂAL[{[h͂ꂽ󂯎悤ɂȂB
   * @return ˂ true
   */
  public boolean isFocusable() {
    return true;
  }

  // `p̃ItCobt@쐬ȂA쐬ăCX^Xϐ
  // display Ɋi[B
  private void getDisplay() {
    if (display == null) {
      display = createImage(getWidth(),getHeight());
      if (display == null) {
        System.err.println("G[: ItCobt@mۂł܂");
        System.exit(1);
      }
      else {
        try {
          clear();
        } catch (InterruptedException e) { }
      }
    }
  }

  public void paintComponent(Graphics g) {
    getDisplay();
    g.drawImage(display,0,0,null);
  }

  /**
   * L[{[h͂ꂽobt@ɕۑB
   * readCharacter \bh̃obt@當ǂݍƂ
   * ubNĂꍇɂ́Ã\bhs notify ɂ
   * obt@ɕۑꂽ΂̕ǂݎB
   * @see java.awt.event.KeyListener#keyTyped(KeyEvent)
   */
  public void keyTyped(KeyEvent e) {
    synchronized (buffer)  {
      buffer.setCharacter(e.getKeyChar());
      buffer.notify();
    }
  }
  public void keyPressed(KeyEvent e) { }
  public void keyReleased(KeyEvent e) { }

  /**
   * w肳ꂽn_I_ցAw肳ꂽFŒ`悷B
   * @param x1 n_XW
   * @param y1 n_YW
   * @param x2 I_XW
   * @param y2 I_YW
   * @param c ̐F
   * @throws InterruptedException
   */
  public void drawLine(double x1, double y1, double x2, double y2, Color c) throws InterruptedException {
    getDisplay();
    Graphics2D g = (Graphics2D)display.getGraphics();
    try {
      g.setColor(c);
      // tgl̘_IȍWnAJAVA AWT̍Wnւ̕ϊs
      AffineTransform at = new AffineTransform();
      at.translate(Width/2,Height/2);
      at.scale(Width/(MaxX-MinX),-Height/(MaxY-MinY));
      g.transform(at);
      g.draw(new Line2D.Double(x1,y1,x2,y2));
    }
    finally {
      g.dispose();
    }
    repaint();
  }

  /**
   * ʂ̃NAsB
   * @throws InterruptedException
   */
  public void clear() throws InterruptedException {
    getDisplay();
    Graphics g = (Graphics)display.getGraphics();
    try {
      // wiFŉʑŜhԂB
      g.setColor(getBackground());
      g.fillRect(0,0,getWidth(),getHeight());
    }
    finally {
      g.dispose();
    }
    repaint();
  }

  /**
   * L[{[h當͂Ă邩ǂׂB
   * L[{[h當͂A̕ǂݎĂȂƂ
   * true ԂBłȂ false ԂB
   * @return ܂ǂݎĂȂȂ trueAȂȂ false
   */
  public boolean isKeyPressed() {
    boolean result;
    synchronized (buffer) {
      result = buffer.hasCharacter();
    }
    return result;
  }

  /**
   * L[{[h͂ꂽ擾B܂ǂݎĂȂ
   * ԂBL[{[h͂ꂽ̓obt@ɕۑĂ̂ŁA
   * obt@̂Ƃ͕obt@ɓǂݍ܂܂ŃXbhҋ@B
   * \bh keyTyped obt@ɕۑƁAXbhĊJA
   * ۑobt@ǂݎB
   * @return L[{[h͂ꂽ
   */
  public char readCharacter() {
    char c;
    synchronized (buffer) {
      if (!buffer.hasCharacter()) {
        try {
          buffer.wait();
        } catch (InterruptedException e) { }
      }
      c = buffer.getCharacter();
    }
    return c;
  }

  /**
   * L[{[h͂ꂽۑobt@
   */
  private class CharacterBuffer {
    char charRead = 0;  // obt@
    
    // obt@ۑĂ邩ǂׂ
    synchronized boolean hasCharacter() {
      return charRead != 0;
    }
    
    // obt@當𓾂
    synchronized char getCharacter() {
      char v = charRead;
      charRead = 0;
      return v;
    }

    // obt@ɕi[
    synchronized void setCharacter(char c) {
      charRead = c;
    }
  }
}
