/*
 * 쐬: 2008/06/21
 * author: Taro Suzuki
 *
 * L\̒`
 *
 */
package tgl.compiler;

import java.util.Collection;
import java.util.HashMap;

import tgl.compiler.error.AlreadyAsProcError;
import tgl.compiler.error.AlreadyAsVarError;
import tgl.compiler.error.CompileErrorHandler;
import tgl.compiler.error.DeclaredAsCommError;
import tgl.compiler.error.DeclaredAsFuncError;
import tgl.compiler.error.DeclaredAsProcError;
import tgl.compiler.error.DeclaredAsVarError;
import tgl.compiler.error.ProcDefDuplicationError;
import tgl.compiler.error.ProcDuplicationError;
import tgl.compiler.error.ProcKindMismatchError;
import tgl.compiler.error.ProcNotDeclaredError;
import tgl.compiler.error.ProcNotDefinedError;
import tgl.compiler.error.VarDuplicationError;
import tgl.compiler.error.VarNotDeclaredError;
import tgl.interpreter.SystemProc;
import tgl.interpreter.SystemProcDecl;
import tgl.interpreter.SystemProcManager;

/**
 * L\̃NXBO[oϐƎ葱ۑ邽߂̑IȋL\ 
 * globalTable ƁAǏϐƉۑ邽߂̋ǏIȋL\ 
 * localTable 2ɂB
 */
class SymbolTable {
  private HashMap<String,SymbolEntry> globalTable;
  private HashMap<String,SymbolEntry> localTable;
  private CompileErrorHandler errorHandler;
  private int localVarLocation;
  private int paramLocation;

  /**
   * L\̃CX^X쐬B
   * @param handler RpĈ߂̃G[nh
   * @throws Exception
   */
  SymbolTable(CompileErrorHandler handler) throws Exception {
    errorHandler = handler;
    globalTable = new HashMap<String,SymbolEntry>();
    localTable = new HashMap<String,SymbolEntry>();
    addSystemProcedures(SystemProcManager.getAllSystemProcedures());
    addCommand("main",0);
  }

  /**
   * vÕRpCIɁA錾ς̃[U葱
   * ׂĒ`ꂽǂ𒲂ׂB
   * 錾ꂽ̂ɒ`ĂȂ֐G[񍐂B
   */
  void checkProgram() throws Exception {
    // IȋL\̃Ggɒׂ
    Collection<SymbolEntry> entryList = globalTable.values();
    for (SymbolEntry entry : entryList)  {
      // ̃Gg葱GgŁA`ȂG[񍐂
      if (entry.isProcedure() && !((ProcEntry)entry).isDefined())
        (new ProcNotDefinedError(entry.getName())).error(errorHandler);
    }
  }

  /**
   * ׂẴVXe`葱L\ globalTable ɓo^B
   * @param decls VXe`葱̐錾̂߂̏ێz
   */
  private void addSystemProcedures(SystemProcDecl [] decls) {
    for (int i=0; i<decls.length; i++)  {
      String name = decls[i].getName();
      int params = decls[i].getParamNum();
      SystemProc system = decls[i].getSystem();
      ProcClass pclass = decls[i].isCommand() ? ProcClass.Command : ProcClass.Function;
      ProcEntry proc = new ProcEntry(pclass,name,params,system);
      globalTable.put(name, proc);
    }
  }

  /**
   * O[oϐL\ globalTable ɓo^B
   * @param name O[oϐ
   * @param loc ϐ蓖Ă̈̐ÓIf[^̈撆̔Ԓn
   * @return o^O[oϐ̂߂̕ϐGg
   * @throws Exception
   */
  VarEntry addGlobalVariable(String name, int loc) throws Exception {
    return addVariable(name,loc,VarClass.Global,globalTable);    
  }

  /**
   * ǏϐL\ localTable ɓo^B
   * @param name Ǐϐ
   * @return o^Ǐϐ̂߂̕ϐGg
   * @throws Exception
   */
  VarEntry addLocalVariable(String name) throws Exception {
    return addVariable(name,localVarLocation++,VarClass.Local,localTable);
  }

  /**
   * L\ localTable ɓo^B
   * @param name 
   * @return o^̂߂̕ϐGg
   * @throws Exception
   */
  VarEntry addParameter(String name) throws Exception {
    return addVariable(name,paramLocation++,VarClass.Parameter,localTable);
  }

  /**
   * ϐL\ɓo^B
   * @param name ϐ
   * @param loc ϐ̔Ԓn
   * @param c ϐ̎
   * @param table ϐo^L\
   * @return ϐGg
   * @throws Exception
   */
  private VarEntry addVariable(String name, int loc, VarClass c, HashMap<String,SymbolEntry> table)
           throws Exception {
    SymbolEntry symbol = table.get(name);
    if (symbol != null)  {
      if (symbol.isVariable())
        (new VarDuplicationError(name)).error(errorHandler);
      else
        (new AlreadyAsProcError(name)).error(errorHandler);
    }
    VarEntry var = new VarEntry(name,loc,c);
    table.put(name,var);
    return var;
  }

  /**
   * R}hL\ globalTable ɓo^Bۂ̏̓vCx[g
   * \bh addProcedure ōsB
   * @param name R}h
   * @param paramNum ̌
   * @return o^R}h̎葱Gg
   * @throws Exception
   */
  ProcEntry addCommand(String name, int paramNum) throws Exception {
    return addProcedure(name,paramNum,ProcClass.Command);
  }

  /**
   * ֐L\ globalTable ɓo^Bۂ̏̓vCx[g
   * \bh addProcedure ōsB
   * @param name ֐
   * @param paramNum ̌
   * @return o^֐̎葱Gg
   * @throws Exception
   */
  ProcEntry addFunction(String name, int paramNum) throws Exception {
    return addProcedure(name,paramNum,ProcClass.Function);
  }

  /**
   * 葱L\ globalTable ɓo^B
   * @param name 葱
   * @param param 
   * @param pclass
   * @return
   * @throws Exception
   */
  private ProcEntry addProcedure(String name, int param, ProcClass pclass) throws Exception {
    SymbolEntry symbol = globalTable.get(name);
    if (symbol != null)  {
      if (symbol.isProcedure())
        (new ProcDuplicationError(name)).error(errorHandler);
      else
        (new AlreadyAsVarError(name)).error(errorHandler);
    }
    ProcEntry proc = new ProcEntry(pclass,name,param);
    globalTable.put(name,proc);
    return proc;
  }

  /**
   * R}h̒`瓾L\ɓo^Bۂ̏
   * vCx[gȃ\bh defineProcedure ōsB
   * @param name R}h
   * @return R}h̏葱Gg
   * @throws Exception
   */
  ProcEntry defineCommand(String name) throws Exception {
    return defineProcedure(name,ProcClass.Command);
  }

  /**
   * ֐̒`瓾L\ɓo^Bۂ̏
   * vCx[gȃ\bh defineProcedure ōsB
   * @param name ֐
   * @return ֐̏葱Gg
   * @throws Exception
   */
  ProcEntry defineFunction(String name) throws Exception {
    return defineProcedure(name,ProcClass.Function);
  }

  /**
   * 葱̒`瓾L\ɓo^B
   * 葱̐錾ƒ`vĂȂA葱`ς݂ɂB
   * @param name 葱
   * @param c 葱̎
   * @return 葱̏葱Gg
   * @throws Exception
   */
  private ProcEntry defineProcedure(String name, ProcClass c) throws Exception {
    ProcEntry proc = findProcedure(name);
    // 葱`ς݂ȂG[
    if (proc.isDefined())
      (new ProcDefDuplicationError(name)).error(errorHandler);
    // 葱̎ʂ錾ƈقȂȂG[
    ProcClass pclass = proc.getProcClass();
    if (c != pclass)
      (new ProcKindMismatchError(name,c.toString(),pclass.toString())).error(errorHandler);
    // ǏϐƉ̃t[Έʒuێϐ
    localVarLocation = 1;
    paramLocation = - proc.getParamNumber();
    // ǏIȋL\NA
    localTable.clear();    
    // 葱`ςɂ
    proc.define();
    return proc;
  }

  /**
   * gpĂϐ̃GgL\猩BGgȂA
   * O̎葱GgȂG[񍐂B
   * @param name ϐ
   * @return ϐGg
   * @throws Exception
   */
  VarEntry findVariable(String name) throws Exception {
    SymbolEntry var = localTable.get(name);

    // ǏIȋL\ɎʎqnameL\GgȂ΁A
    // IȋL\环ʎqnameL\GgT
    if (var == null)
      var = globalTable.get(name);

    // L\GgȂ΃G[
    if (var == null)
      (new VarNotDeclaredError(name)).error(errorHandler);
    // 葱GgG[
    else if (var.isProcedure())
      (new DeclaredAsProcError(name)).error(errorHandler);
    // ϐGgւ̃|C^Ԃ
    return (VarEntry)var;
  }

  /**
   * ĂяoĂ֐̃GgL\猩BGgȂA
   * O̕ϐGg邩A葱R}hƂĐ錾Ă
   * ȂG[񍐂Bۂ̏́AvCx[gȃ\bh findProcedure 
   * sB
   * @param name ֐
   * @return ֐̃Gg
   * @throws Exception
   */
  ProcEntry findFunction(String name) throws Exception {
    ProcEntry proc = findProcedure(name);
    if (proc.isCommand())
      (new DeclaredAsCommError(name)).error(errorHandler);
    return proc;
  }

  /**
   * ĂяoĂR}h̃GgL\猩BGgȂA
   * O̕ϐGg邩A葱֐ƂĐ錾Ă
   * ȂG[񍐂Bۂ̏́AvCx[gȃ\bh findProcedure 
   * sB
   * @param name R}h
   * @return R}h̃Gg
   * @throws Exception
   */
  ProcEntry findCommand(String name) throws Exception {
    ProcEntry proc = findProcedure(name);
    if (proc.isFunction())
      (new DeclaredAsFuncError(name)).error(errorHandler);
    return proc;
  }

  /**
   * ĂяoĂ葱̋L\GgBGgȂA
   * O̕ϐGgȂG[񍐂B
   * @param name
   * @return 葱Gg
   * @throws Exception
   */
  private ProcEntry findProcedure(String name) throws Exception {
    SymbolEntry symbol = globalTable.get(name);

    // L\GgȂ΃G[
    if (symbol == null)
      // 葱錾
      (new ProcNotDeclaredError(name)).error(errorHandler);
    // ϐGgG[
    else if (!symbol.isProcedure())
      // ϐƂĐ錾Ă
      (new DeclaredAsVarError(name)).error(errorHandler);
    // 葱Ggւ̃|C^Ԃ
    return (ProcEntry)symbol;
  }
}
