/****************************************************************
   code.h  ƥ³ξǼ륯饹

****************************************************************/

#ifndef __CODE_H__
#define __CODE_H__

#include <utility>
#include <string>
#include <vector>
#include "const.h"


// ʸڤμ̤ɽ STreeID 
//    Sassign:   ʸ
//    Sif:       ifʸ
//    Swhile:    whileʸ
//    Srepeat:   repeatʸ
//    Sreturn:   returnʸ
//    SlocalVar: ɽѿ
//    Sexpr:     
//    Scond:     
enum STreeID { Sassign, Sif, Swhile, Srepeat, Sreturn, 
               SlocalVar, Sexpr, Scond };

// ιʸڤμ̤ɽ ExprTreeID 
//    ETbinop:    黻Ҥļ
//    ETuniop:    ñ黻Ҥļ
//    ETvar:      ѿ
//    ETnum:      
//    ETcall:     ؿƤӽФ
enum ExprTreeID { ETbinop, ETuniop, ETvar, ETnum, ETcall };


// ʸڤΥ饹 STree
class STree  {
  STreeID _id;		// ʸڤμ
 public:
  // 󥹥ȥ饯
  STree(STreeID id) : _id(id) { }
  // ʸڤμ̤֤дؿ
  STreeID getID() { return _id; }
};

// ֥ɤη Code 
typedef vector<STree *> Code;


// ιʸ
class ExprTree : public STree {
  ExprTreeID _id;	// μ
 public:
  // 󥹥ȥ饯
  ExprTree(ExprTreeID id) : STree(Sexpr), _id(id) { }
  // μ̤֤дؿ
  ExprTreeID getID() { return _id; }
};

// ιʸڤؤΥݥ󥿤η ExprList 
typedef vector<ExprTree *> ExprList;


// 黻Ҥļιʸ
class BinExprTree : public ExprTree {
  CConst _operator;	// 黻Ҥɽ
  ExprTree *_operand1;	// ΰιʸڤؤΥݥ
  ExprTree *_operand2;	// ΰιʸڤؤΥݥ
 public:
  // 󥹥ȥ饯
  BinExprTree(CConst op, ExprTree *op1, ExprTree *op2) : ExprTree(ETbinop)  {
    _operator = op; _operand1 = op1; _operand2 = op2;
  }
  // Ф˥뤿Υдؿ
  CConst getOperator() { return _operator; }
  ExprTree *getFirstOperand() { return _operand1; }
  ExprTree *getSecondOperand() { return _operand2; }
};

// ñ黻Ҥļιʸ
class UniExprTree : public ExprTree {
  CConst _operator;	// 黻Ҥɽ
  ExprTree *_operand;	// ιʸڤؤΥݥ
 public:
  // 󥹥ȥ饯
  UniExprTree(CConst op, ExprTree *op1) : ExprTree(ETuniop)  {
    _operator = op; _operand = op1;
  }
  // Ф˥뤿Υдؿ
  CConst getOperator() { return _operator; }
  ExprTree *getOperand() { return _operand; }
};

// ѿιʸ
class VarNode : public ExprTree {
  string _name;	// ѿ̾
  int _loc;	// ѿΥǤΰ
  bool _global;	// ѿɤɽե饰
                // ѿʤ true, ʳ false
 public:
  // 󥹥ȥ饯
  VarNode(string name, int loc, bool global) : ExprTree(ETvar)  {
    _name = name; _loc = loc; _global = global;
  }
  // Ф˥뤿Υдؿ
  string getName() { return _name; }
  int getLocation() { return _loc; }
  bool isGlobal() { return _global; }
};

// ιʸ
class NumNode : public ExprTree {
  int  _num;	// 
 public:
  // 󥹥ȥ饯
  NumNode(int number) : ExprTree(ETnum)  {
    _num = number;
  }
  // Ф˥뤿Υдؿ
  int getValue() { return _num; }
};

// ιʸ
class CondTree : public STree {
  CConst _operator;	// 黻Ҥɽ
  ExprTree *_operand1;	// դμιʸڤؤΥݥ
  ExprTree *_operand2;	// դμιʸڤؤΥݥ
 public:
  CondTree(CConst op, ExprTree *op1, ExprTree *op2) : STree(Scond)  {
    _operator = op; _operand1 = op1; _operand2 = op2;
  }
  // Ф˥뤿Υдؿ
  CConst getOperator() { return _operator; }
  ExprTree *getFirstOperand() { return _operand1; }
  ExprTree *getSecondOperand() { return _operand2; }
};

// ȥɤΥڥ
typedef vector<pair<CondTree *, Code *> > CondList;


// ʸιʸ
class AssignTree : public STree {
  VarNode *_var;	// ͤѿιʸ
  ExprTree *_expr;	// 뼰ιʸڤؤΥݥ
 public:
  // 󥹥ȥ饯
  AssignTree(VarNode *var, ExprTree *expr) : STree(Sassign)  {
    _var = var; _expr = expr;
  }
  // Ф˥뤿Υдؿ
  int getLocation() { return _var->getLocation(); }
  string getName() { return _var->getName(); }
  ExprTree *getExpression() { return _expr; }
  bool isGlobal() { return _var->isGlobal(); }
};

// ifʸιʸ
class IfTree : public STree {
  CondList *_cond;	// ȼ¹ԤʸꥹȤΥڥ
  Code *_elsePart;	// ٤Ƥξ郎ΤȤ˼¹Ԥʸꥹ
 public:
  // 󥹥ȥ饯
  IfTree(CondList *cond, Code *elsePart) : STree(Sif)  {
    _cond = cond; _elsePart = elsePart;
  }
  // Ф˥뤿Υдؿ
  CondList *getCondList() { return _cond; }
  Code *getElsePart() { return _elsePart; }
};

// whileʸιʸ
class WhileTree : public STree {
  CondTree *_cond;	// 
  Code *_body;		// 
 public:
  // 󥹥ȥ饯
  WhileTree(CondTree *cond, Code *body) : STree(Swhile)  {
    _cond = cond; _body = body;
  }
  // Ф˥뤿Υдؿ
  CondTree *getCondition() { return _cond; }
  Code *getBody() { return _body; }
};

// repeatʸιʸ
class RepeatTree : public STree {
  ExprTree *_count;	// ֤β
  Code *_body;		// 
 public:
  // 󥹥ȥ饯
  RepeatTree(ExprTree *count, Code *body) : STree(Srepeat)  {
    _count = count; _body = body;
  }
  // Ф˥뤿Υдؿ
  ExprTree *getCount() { return _count; }
  Code *getBody() { return _body; }
};

// ƥ³¸CؿηSystemProc
typedef void (*SystemProc)(void);


// ³ƤӽФιʸڤ
class CallTree : public ExprTree {
  ExprList *_args;	// 
  Code *_code;		// ƤӽФ³
  string _name;		// ³μ̻̾
  SystemProc _sysProc;	// ƥ³ΤȤбCؿ
 public:
  // 󥹥ȥ饯ʥ桼³θƤӽФѡ
  CallTree(string name, ExprList *args, Code *code)
    : ExprTree(ETcall), _name(name), _code(code), _args(args),
      _sysProc(NULL) { }
  // 󥹥ȥ饯ʥƥ³θƤӽФѡ
  CallTree(string name, ExprList *args, SystemProc sys)
    : ExprTree(ETcall), _name(name), _code(NULL), _args(args),
      _sysProc(sys) { }
  // Ф˥뤿Υдؿ
  ExprList *getArguments() { return _args; }
  Code *getCode() { return _code; }
  string getName() { return _name; }
  SystemProc getSystemProcedure() { return _sysProc; }
  void setSystemProcedure(SystemProc proc) { _sysProc = proc; }
};

// returnʸιʸ
class ReturnTree : public STree {
  ExprTree *_expr;	// ֤ͤμιʸڤؤΥݥ
  int _paramNum;	// returnʸޤ³βĿ
 public:
  // 󥹥ȥ饯
  ReturnTree(ExprTree *expr, int paramNum)
    : STree(Sreturn), _expr(expr), _paramNum(paramNum) { }
  // Ф˥뤿Υдؿ
  ExprTree *getExpression() { return _expr; }
  int getParamNumber() { return _paramNum; }
};

// ɽѿΤιʸ
class LocalVarTree : public STree {
  string _name;		// ɽѿ̾
  ExprTree *_expr;	// ɽѿνͤιʸڤؤΥݥ
 public:
  // 󥹥ȥ饯
  LocalVarTree(string name, ExprTree *expr)
    : STree(SlocalVar), _name(name), _expr(expr) { }
  // Ф˥뤿Υдؿ
  string getName() { return _name; }
  ExprTree *getExpression() { return _expr; }
};


// 󥿡ץ꥿ƤؿΥץȥ

// 󥿡ץ꥿νԤ
void initializeInterpreter(void);
// codeؤ̿¹Ԥ
void interpret(Code *code);
// ̾nameѿνval򡤥˳Ƥ
// ֤ͤϡѿ˳Ƥ줿
int allocateMemory(string name, double val);
// 󥿥ץ꥿μ¹®٤ꤹ
void setSpeed(int speed);


#endif
