#
# 18-1.py
#
import pandas # pandasをインポート
import numpy
from matplotlib import pyplot # pyplotをインポート
from sklearn.decomposition import PCA
from scipy.stats import zscore
#irisのデータ読み込み
iris = pandas.read_csv("iris.csv", sep=',')
data = iris[["Petal.Length","Petal.Width","Sepal.Length","Sepal.Width"]]#データフレームで切り出し
species = iris["Species"]#リストとして切り出し
data_nomalized=zscore(data)#正規化
pca = PCA(n_components=4)#主成分分析準備
pca.fit(data_nomalized) #主成分分析実行

print("Contributions")#寄与率の表示
print(pca.explained_variance_ratio_)
print("Loadings")#主成分負荷量の計算と表示
loadings = pca.components_*numpy.c_[numpy.sqrt(pca.explained_variance_)]
print(loadings)
score = pca.fit_transform(data) #主成分スコアの計算とグラフの表示
pyplot.scatter(score[:, 0], score[:, 1])
for i in range(len(species)): #種名を書きだす
    pyplot.text(score[i, 0], score[i, 1], species[i])
pyplot.show() #デンドログラムを表示