#
#18-2.py
#
import pandas # pandasをインポート
import numpy
from matplotlib import pyplot # pyplotをインポート
from sklearn.decomposition import PCA
from scipy.stats import zscore
#irisのデータ読み込み
iris = pandas.read_csv("iris.csv", sep=',')
data = iris[["Petal.Length","Petal.Width","Sepal.Length","Sepal.Width"]]#データフレームで切り出し
species = iris["Species"]#リストとして切り出し
data_nomalized=zscore(data)#正規化
pca = PCA(n_components=4)#主成分分析準備
pca.fit(data_nomalized) #主成分分析実行

print("Contributions")#寄与率の表示
print(pca.explained_variance_ratio_)
print("Loadings")#主成分負荷量の計算と表示
loadings = pca.components_*numpy.c_[numpy.sqrt(pca.explained_variance_)]
print(loadings)
score = pca.fit_transform(data) #スコアの計算
fig = pyplot.figure()#図を用意する
ax = fig.add_subplot(1,1,1)#subplot追加
#50個ずつsetosa, versicolor, virginica の順
ax.scatter(score[0:50, 0], score[0:50, 1], c='red', label='setosa')
ax.scatter(score[50:100, 0], score[50:100, 1], c='blue', label='versicolor')
ax.scatter(score[100:150, 0], score[100:150, 1], c='green', label='virginica')

ax.set_title('PCA')
ax.set_xlabel('PC1 ')
ax.set_ylabel('PC2 ')
ax.legend(loc='upper left')
fig.show()
