#
# 20-1.py
#
import pandas, numpy # pandas numpyをインポート
from scipy.cluster import hierarchy # Scipyの階層化クラスタリングモジュールをインポート
from matplotlib import pyplot # pyplotのモジュールをインポート
#irisのデータ読み込み
iris = pandas.read_csv("iris.csv", sep=',')
data = iris.iloc[:, 1:5]#データの切り出し
species = iris.iloc[:, 5]#種データの切り出し
#階層化クラスタリングの実行
hct = hierarchy.linkage(data, metric = 'euclidean', method= 'complete')
hierarchy.dendrogram(hct, labels = list(species)) #デンドログラムを作成
result = numpy.ndarray.flatten(hierarchy.cut_tree(hct,3))
#pandas.crosstabで結果を集約
print(pandas.crosstab(species,result))
pyplot.show() #デンドログラムを表示
