#
# 21-2.py
#
from sklearn.utils import resample #ブートストラップ用のモジュール
from scipy.stats import pearsonr,spearmanr
leu = [1.7,6.2,4.3,5.3,4.7,7.5,5.7,3.9,7.1,3.9,7.5,5.0,4.8,5.9,5.8,7.5,5.1,6.9,6.3,7.3] #ロイシンのデータ
ile = [3.4,11.7,12.1,13.1,13.3,13.6,13.6,14.3,15.0,9.5,16.7,17.0,17.3,17.7,18.6,19.1,19.2,21.2,21.5,21.9] #イソロイシンのデータ
data = []
for i in range(10000):
    tleu, tile = resample(leu, ile,n_samples = 20) #leu, ileから20回復元抽出したリストを作成
    r, pvalue = spearmanr(tleu, tile)
    data.append(r)
data.sort() #データをソート
print(data[251],data[9750]) #95%信頼区間の下限と上限を表示
