# -*- coding: utf-8 -*-
"""
namelist3.pyプログラム
オブジェクトを利用した名簿作成プログラム
継承の利用例
"""
# クラス定義
# Personクラス
class Person:
    """名簿の1項目を表現するクラスの定義"""
    def __init__(self, name, age):  # コンストラクタ
        self.name = name   # 名前
        self.age = age     # 年齢
    def get_name(self):   # 名前を返す
        return self.name
    def get_age(self):    # 年齢を返す
        return self.age

# NewPersonクラス
class NewPerson(Person):
    """Personクラスを継承した子クラスの定義"""
    def __init__(self, name, age, address):  # コンストラクタ
        super().__init__(name, age) # 親クラスのコンストラクタを利用
        self.address = address    # アドレス
    def get_address(self):# アドレスを返す
        return self.address
    def set_address(self, address):# アドレスを設定する
        self.address = address
        return 

# メイン実行部
# クラスからのインスタンスの生成
# NewPersonクラスからの生成
person1 = NewPerson("taro", 22, "taro@mail") 
print(person1.get_name(), person1.get_age(), person1.get_address())
person1.set_address("taro@othermail")
print(person1.get_name(), person1.get_age(), person1.get_address())

# Personクラスからの生成
person2 = Person("jiro", 19)
print(person2.get_name(), person2.get_age())