# -*- coding: utf-8 -*-
"""
monte.pyプログラム
モンテカルロ法による関数の極小値探索
"""
# モジュールのインポート
import random
# 下請け関数の定義
# f()関数
def f(x,y):
    """関数f()"""
    return x * x + y * y + 1
# f()関数の終わり

# メイン実行部
x = random.uniform(-1, 1)
y = random.uniform(-1, 1)
fmin = f(x,y) # 初期値の設定
for i in range(1000000):# 1000000回の繰り返し
    x = random.uniform(-1, 1)
    y = random.uniform(-1, 1)
    fval = f(x,y)   # 関数値の計算
    if fval < fmin: # 最小値の発見
        fmin = fval # 最小値の更新
        print("f(x,y)=",fmin, "x =", x, "y =",y) # 解候補の出力
